// Jonas Altrock <ew20b126@technikum-wien.at>
//
// [The whole source file `stack.h`.](./stack.h)<br>
// [To the implementation file `stack.c`.](./stack.html)
//
// [Back to `postfix.c`](./postfix.html)
/* */

// This is a so-called include guard. The preprocessor excludes the whole
// section of code from `ifndef` to `endif` if this file is included more than
// once in one compilation unit, and the constant `STACK_H` has already been
// defined. For this exercise it is not necessary, but good practice for
// creating library header files.
#ifndef STACK_H
#define STACK_H

// This is an "opaque struct handle", meaning that we have a typedef for using
// the struct type from the outside, but the fields are not known to code that
// only includes the `stack.h` header file.
//
// It hides that it's a pointer type, but that's ok for a handle.
// We could change the semantics of this handle and make it a non-pointer type,
// and the users of this code would not have to change anything.
typedef struct stack* stack_handle_t;

// Create a stack (on the heap).
stack_handle_t stack_create();

// Free the memory allocated by `stack_create`.
void stack_destroy(stack_handle_t);

// Peek at the top value on stack.
int stack_top(stack_handle_t);

// Push a value to the stack.
void stack_push(stack_handle_t, int);

// Pop the top value off the stack.
int stack_pop(stack_handle_t);

// Get the height of the stack.
int stack_len(stack_handle_t);

#endif